﻿using System;
using System.Web;
using System.Collections.Generic;
using System.Linq;
using System.Web.UI.WebControls;
using System.Data;
using System.Web.Security.AntiXss;
using VIRP_WEB.BaseCode;
using VIRP_WEB.SoaServices;
using VIRP.EFR.BLL;
using VIRP.EFR.BO;

namespace VIRP_WEB.Custom.EFR
{
    public partial class FragmentDetails : EfrBasePage
    {
        //LabResultsManager manager = new LabResultsManager();
        //WorkflowCaseManager caseManager = new WorkflowCaseManager();

        private WKF_CASE_ACTIVITY Activity
        {
            get
            {
                WKF_CASE_ACTIVITY activity = null;

                if (ViewState["Activity"] == null)
                {
                    //wkfCase = ServiceInterfaceManager.REGISTRY_COHORT_DATA_GET_ALL_BY_REGISTRY(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                    ViewState["Activity"] = activity;
                }
                else
                {
                    activity = ViewState["Activity"] as WKF_CASE_ACTIVITY;
                }

                return activity;
            }
            set
            {
                ViewState["Activity"] = value;
            }
        }

        private FRAGMENT_ANALYSIS Fragment
        {
            get
            {
                FRAGMENT_ANALYSIS fragment = null;

                if (ViewState["Fragment"] == null)
                {
                    //wkfCase = ServiceInterfaceManager.REGISTRY_COHORT_DATA_GET_ALL_BY_REGISTRY(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                    ViewState["Fragment"] = fragment;
                }
                else
                {
                    fragment = ViewState["Fragment"] as FRAGMENT_ANALYSIS;
                }

                return fragment;
            }
            set
            {
                ViewState["Fragment"] = value;
            }
        }

        //FRAGMENT_ANALYSI fragment;
        int AnalysisId;
        string CurAnalysisMethod;
        string CurrentAnalyte;
        string CurAnalysisTypeName;

        public FragmentDetails()
        {
            //manager.BOSaveSuccess += Manager_BOSaveSuccess;
        }
        protected override void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                int fragmentId;
                if (int.TryParse(Request.QueryString["fragmentId"], out fragmentId))
                {
                    GetRefreshFragment(fragmentId);
                    SetupFragment();
                }
                else
                {
                    BindGridView();
                }

                int activityId;
                if (int.TryParse(Request.QueryString["activityId"], out activityId))
                {
                    Activity = ServiceInterfaceManager.WKF_CASE_ACTIVITY_GET(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, activityId);
                }

                //if (fragment != null && fragment.WKF_CASE_ACTIVITY.STD_WKFACTIVITYSTS_ID == (int)VIRP.EFR.BO.WorkflowCaseActivityStatus.Accepted)
                if (Activity != null && Activity.STD_WKFACTIVITYSTS_ID == (int)VIRP.EFR.BO.WorkflowCaseActivityStatus.Accepted)
                {
                    SaveButton.Enabled = false;

                    if (GridViewAnalyteData.FooterRow != null)
                    {
                        GridViewAnalyteData.FooterRow.Visible = false;
                        GridViewAnalyteData.Columns[0].Visible = false;
                    }
                    else
                    {
                        if (GridViewAnalyteData.Controls.Count > 0)
                        {
                            GridViewAnalyteData.Controls[0].Controls[0].Visible = false;
                        }
                    }
                }
            }

            //int activityId;
            //if (int.TryParse(Request.QueryString["activityId"], out activityId))
            if (Activity != null)
            {
                STD_WKFACTIVITYSTS status = ServiceInterfaceManager.STD_WKFACTIVITYSTS_GET(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, Activity.STD_WKFACTIVITYSTS_ID);
                if (status != null)
                {
                    if (Fragment == null)
                    {
                        ReplacePageTitle("My Tasks > Lab Results > " + status.NAME + " > Workflow ID " + Activity.WKF_CASE_ID.ToString() + " > Fragments > New");
                    }
                    else
                    {
                        ReplacePageTitle("My Tasks > Lab Results > " + status.NAME + " > Workflow ID " + Activity.WKF_CASE_ID.ToString() + " > Fragments > Fragment ID > " + Fragment.FRAGMENT_ID_NUMBER);
                    }                    
                }
            }
        }

        private void SetupFragment()
        {
            txtFragmentId.Text = Fragment.FRAGMENT_ID_NUMBER;
            txtFragDesc.Text = Fragment.FRAGMENT_DESCR;
            txtFragMass.Text = Fragment.FRAGMENT_MASS_MEASURE;
            ddlMassmsrmts.SelectedIndex = ddlMassmsrmts.Items.IndexOf(ddlMassmsrmts.Items.FindByText(Fragment.MASS_UNITS));

            txtLength.Text = string.IsNullOrEmpty(Fragment.FRAGMENT_LENGTH_MEASURE) ? String.Empty : Fragment.FRAGMENT_LENGTH_MEASURE.Split(' ')[0];

            if (!string.IsNullOrEmpty(Fragment.FRAGMENT_LENGTH_MEASURE))
            {
                if (Fragment.FRAGMENT_LENGTH_MEASURE.Split(' ').Length > 1)
                    ddlLengthmsrmts.SelectedValue = Fragment.FRAGMENT_LENGTH_MEASURE.Split(' ')[1];

                txtHeight.Text = string.IsNullOrEmpty(Fragment.FRAGMENT_HEIGHT_MEASURE) ? String.Empty : Fragment.FRAGMENT_HEIGHT_MEASURE.Split(' ')[0];
            }

            if (!string.IsNullOrEmpty(Fragment.FRAGMENT_HEIGHT_MEASURE))
            {
                if (Fragment.FRAGMENT_HEIGHT_MEASURE.Split(' ').Length > 1)
                    ddlHeightmsrmts.SelectedValue = Fragment.FRAGMENT_HEIGHT_MEASURE.Split(' ')[1];
            }

            if (!String.IsNullOrEmpty(Fragment.FRAGMENT_WIDTH_MEASURE))
            {
                txtWidth.Text = String.IsNullOrEmpty(Fragment.FRAGMENT_WIDTH_MEASURE) ? String.Empty : Fragment.FRAGMENT_WIDTH_MEASURE.Split(' ')[0];
                if (Fragment.FRAGMENT_WIDTH_MEASURE.Split(' ').Length > 1)
                    ddlWidthmsrmts.SelectedValue = Fragment.FRAGMENT_WIDTH_MEASURE.Split(' ')[1];
            }

            radRadioactive.SelectedValue = Fragment.FRAGMENT_RADIOACTIVE_TEST_IND.ToString();

            txtRadActiveTestResult.Text = Fragment.FRAGMENT_RADIOACTIVE_RESULT;
            txtComments.Text = Fragment.COMMENT_TEXT;
            radTissueSent.SelectedValue = Fragment.TISSUE_SENT_FLAG.ToString();
            txtTissueResults.Text = Fragment.TISSUE_RESULT_TEXT;

            BindGridView();
        }

        private void SaveCompleteFragment()
        {
            if (Fragment != null)
            {
                //Fragment.SetAsChangeTrackingRoot(true);
                SaveFragment();
            }
            else
            {
                Fragment = AddNewFragment();
                //Fragment.SetAsChangeTrackingRoot(true);
                SaveFragment();
                //Fragment.SetAsInsertOnSubmit();
            }
            //set questionnaire in-process status

            //Fragment saved in SaveFragment function above
            //Fragment.FRAGMENT_ANALYSIS_ID = FRAGMENT_ANALYSISManager.Save(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, Fragment);
            //manager.UpdateFragment(Fragment);

            GetRefreshFragment(Fragment.FRAGMENT_ANALYSIS_ID);
            SetupFragment();

            //int activityId;
            //if (int.TryParse(Request.QueryString["activityId"], out activityId))
            if (Activity != null)
            {
                STD_WKFACTIVITYSTS status = ServiceInterfaceManager.STD_WKFACTIVITYSTS_GET(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, Activity.STD_WKFACTIVITYSTS_ID);
                if (status != null)
                {
                    ReplacePageTitle("My Tasks > Lab Results > " + status.NAME + " > Workflow ID " + Activity.WKF_CASE_ACTIVITY_ID.ToString() + " > Fragments > Fragment ID > " + Fragment.FRAGMENT_ID_NUMBER);
                }
            }

            ClientScript.RegisterStartupScript(this.GetType(), "alertMessage", "<script type='text/javascript'>alert('Save Successful');</script>");
        }

        private void SaveFragment()
        {
            Fragment.FRAGMENT_ID_NUMBER = txtFragmentId.Text;
            Fragment.FRAGMENT_DESCR = txtFragDesc.Text;
            Fragment.FRAGMENT_MASS_MEASURE = txtFragMass.Text;
            Fragment.MASS_UNITS = ddlMassmsrmts.SelectedValue;
            Fragment.FRAGMENT_LENGTH_MEASURE = txtLength.Text + ' ' + ddlLengthmsrmts.SelectedValue;
            Fragment.FRAGMENT_HEIGHT_MEASURE = txtHeight.Text + ' ' + ddlHeightmsrmts.SelectedValue;
            Fragment.FRAGMENT_WIDTH_MEASURE = txtWidth.Text + ' ' + ddlWidthmsrmts.SelectedValue;
            Fragment.FRAGMENT_RADIOACTIVE_TEST_IND = radRadioactive.SelectedValue;
            Fragment.FRAGMENT_RADIOACTIVE_RESULT = txtRadActiveTestResult.Text;
            Fragment.COMMENT_TEXT = txtComments.Text;
            if (radTissueSent.SelectedValue != "") Fragment.TISSUE_SENT_FLAG = Convert.ToBoolean(radTissueSent.SelectedValue);
            Fragment.TISSUE_RESULT_TEXT = txtTissueResults.Text;

            Fragment.FRAGMENT_ANALYSIS_ID = FRAGMENT_ANALYSISManager.Save(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, Fragment);

            int activityId;

            if (int.TryParse(Request.QueryString["activityId"], out activityId))
            {
                WKF_CASE_ACTIVITY activity = ServiceInterfaceManager.WKF_CASE_ACTIVITY_GET(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, activityId);
                if (activity != null)
                {
                    //WKF_CASE_ACTIVITY activity = caseManager.getActivityByID(activityId);
                    //activity = SerializerUtil.Deserialize<WKF_CASE_ACTIVITY>(activity.Serialize());
                    activity.STD_WKFACTIVITYSTS_ID = Convert.ToInt16(VIRP.EFR.BO.WorkflowCaseActivityStatus.InProcess);
                    //caseManager.Update(activity);
                    activity.WKF_CASE_ACTIVITY_ID = ServiceInterfaceManager.WKF_CASE_ACTIVITY_SAVE(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, activity);
                }
            }
        }

        private void GetRefreshFragment(int fragId)
        {
            Fragment = FRAGMENT_ANALYSISManager.GetItem(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, fragId);
            //Fragment = manager.getFragByFragmentID(fragId);
            //if (Fragment != null)
            //{
            //    Fragment.SetAsChangeTrackingRoot();
            //}
        }

        private void BindGridView()
        {
            bool enableAddButton = false;
            if (Fragment != null)
            {
                List<ANALYSIS_DETAIL> detailList = ANALYSIS_DETAILManager.GetItemsByFragment(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, Fragment.FRAGMENT_ANALYSIS_ID);
                //if (Fragment.ANALYSIS_DETAILs.Count() > 0)
                if (detailList != null)
                {
                    GridViewAnalyteData.DataSource = detailList;
                    //GridViewAnalyteData.DataSource = Fragment.ANALYSIS_DETAILs;
                }
                else
                {
                    GridViewAnalyteData.DataSource = new List<ANALYSIS_DETAIL>();
                }
                enableAddButton = true;
            }
            else
            {
                GridViewAnalyteData.DataSource = new List<ANALYSIS_DETAIL>();
                enableAddButton = false;
            }

            GridViewAnalyteData.DataBind();
            EnableAddAnlyteButton(enableAddButton);
        }

        private void EnableAddAnlyteButton(bool enable)
        {
            Button addAnalyteButton = null;
            if (GridViewAnalyteData.FooterRow != null)
            {
                addAnalyteButton = GridViewAnalyteData.FooterRow.FindControl("btnAddAnalyte") as Button;
            }
            if (addAnalyteButton == null)
            {
                if (GridViewAnalyteData.Controls.Count > 0)
                {
                    addAnalyteButton = GridViewAnalyteData.Controls[0].Controls[0].FindControl("btnedtAddAnalyte") as Button;
                }
            }
            if (addAnalyteButton != null)
            {
                addAnalyteButton.Enabled = enable;
            }
        }

        //gridview events
        protected void GridViewAnalyteData_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            DropDownList ddlMethods = (DropDownList)e.Row.FindControl("ddlMethodDesc");
            if (ddlMethods != null)
                ddlMethods.SelectedIndex = ddlMethods.Items.IndexOf(ddlMethods.Items.FindByText(CurAnalysisMethod));

            DropDownList ddlAnalytes = (DropDownList)e.Row.FindControl("ddlAnalytes");
            if (ddlAnalytes != null)
                ddlAnalytes.SelectedIndex = ddlAnalytes.Items.IndexOf(ddlAnalytes.Items.FindByText(CurrentAnalyte));

            DropDownList ddlMethodTypes = (DropDownList)e.Row.FindControl("ddlMethodType");

            if (ddlMethodTypes != null)
                ddlMethodTypes.SelectedIndex = ddlMethodTypes.Items.IndexOf(ddlMethodTypes.Items.FindByText(CurAnalysisTypeName));
        }

        protected void GridViewAnalyteData_RowEditing(object sender, GridViewEditEventArgs e)
        {
            GridViewAnalyteData.EditIndex = e.NewEditIndex;

            GridViewAnalyteData.SelectedIndex = GridViewAnalyteData.EditIndex;
            Label lblMethod = (Label)GridViewAnalyteData.Rows[e.NewEditIndex].FindControl("lblMethodDesc");
            CurAnalysisMethod = lblMethod.Text;

            Label lblAnalyte = (Label)GridViewAnalyteData.Rows[e.NewEditIndex].FindControl("lblAnalyte");
            CurrentAnalyte = lblAnalyte.Text;

            Label lblType = (Label)GridViewAnalyteData.Rows[e.NewEditIndex].FindControl("lblMethodType");
            CurAnalysisTypeName = lblType.Text;

            BindGridView();
            GridViewAnalyteData.FooterRow.Visible = false;
        }

        protected void GridViewAnalyteData_RowCancelingEdit(object sender, GridViewCancelEditEventArgs e)
        {
            GridViewAnalyteData.EditIndex = -1;
            GridViewAnalyteData.SelectedIndex = -1;

            GetRefreshFragment(Fragment.FRAGMENT_ANALYSIS_ID);
            BindGridView();
            GridViewAnalyteData.FooterRow.Visible = true;
        }

        protected void GridViewAnalyteData_RowUpdating(object sender, GridViewUpdateEventArgs e)
        {
            GridViewRow Row = GridViewAnalyteData.Rows[e.RowIndex];

            ANALYSIS_DETAIL AnalysisDetail = ANALYSIS_DETAILManager.GetItem(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, AnalysisId);
            //ANALYSIS_DETAIL AnalysisDetail = Fragment.ANALYSIS_DETAILs.Where(d => d.ANALYSIS_DETAIL_ID == AnalysisId).SingleOrDefault();
            //AnalysisDetail.SetAsChangeTrackingRoot(true);
            AnalysisDetail.STD_ANALYSISMETHOD_ID = Convert.ToInt32(((DropDownList)Row.FindControl("ddlMethodDesc")).SelectedValue);
            AnalysisDetail.STD_FRAGMENT_ANALYSIS_TYPE_ID = Convert.ToInt32(((DropDownList)Row.FindControl("ddlMethodType")).SelectedValue);
            AnalysisDetail.EVAL_COMMENT_TEXT = ((TextBox)Row.FindControl("txtComments")).Text;
            AnalysisDetail.RESULT_TEXT = ((TextBox)Row.FindControl("txtAnalytePercentage")).Text;
            AnalysisDetail.CAS_NUMBER = ((TextBox)Row.FindControl("txtCASNumber")).Text;
            AnalysisDetail.ANALYSIS_METHOD_NAME = ((TextBox)Row.FindControl("txtOthrAnalysisMthdTxt")).Text;
            AnalysisDetail.OTHER_ANALYTETYPE_NAME = ((TextBox)Row.FindControl("txtAnalyte")).Text;
            AnalysisDetail.STD_ANALYTETYPE_ID = Convert.ToInt32(((DropDownList)Row.FindControl("ddlAnalytes")).SelectedValue);

            //Save Analysis detail here
            SuppressSaveSuccessMessage = true;
            AnalysisDetail.ANALYSIS_DETAIL_ID = ANALYSIS_DETAILManager.Save(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, AnalysisDetail);
            Fragment.FRAGMENT_ANALYSIS_ID = FRAGMENT_ANALYSISManager.Save(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, Fragment);
            //manager.UpdateFragment(Fragment);
            GridViewAnalyteData.EditIndex = -1;
            GetRefreshFragment(Fragment.FRAGMENT_ANALYSIS_ID);
            BindGridView();
            GridViewAnalyteData.FooterRow.Visible = true;
        }

        protected void GridViewAnalyteData_RowCommand(object sender, GridViewCommandEventArgs e)
        {
            //Data key value is retrieved here. Row updating event returing null.
            if (e.CommandName == "Update" || e.CommandName == "Delete")
            {
                int index = Convert.ToInt32(e.CommandArgument);
                GridViewAnalyteData.SelectedIndex = index;
                AnalysisId = Convert.ToInt32(GridViewAnalyteData.SelectedDataKey.Values[0]);
            }

            if (e.CommandName == "Edit")
            {
                gridViewEditModeFlag.Value = "1";
            }

            if (e.CommandName == "Cancel" || e.CommandName == "Update")
            {
                gridViewEditModeFlag.Value = "0";
            }
            if (e.CommandName == "Add" || e.CommandName == "AddNewRow")
            {
                gridViewAddNewModeFlag.Value = "1";

                ANALYSIS_DETAIL AnalysisDetail = new ANALYSIS_DETAIL();

                AnalysisDetail.CREATED = AnalysisDetail.UPDATED = DateTime.Now;
                AnalysisDetail.CREATEDBY = AnalysisDetail.UPDATEDBY = CurrentUser;

                //AnalysisDetail.SetAsChangeTrackingRoot(true);

                if (e.CommandName == "Add")
                {
                    AnalysisDetail.STD_ANALYSISMETHOD_ID = Convert.ToInt32(((DropDownList)GridViewAnalyteData.FooterRow.FindControl("ddlftrMethodDesc")).SelectedValue);
                    AnalysisDetail.STD_FRAGMENT_ANALYSIS_TYPE_ID = Convert.ToInt32(((DropDownList)GridViewAnalyteData.FooterRow.FindControl("ddlftrMethodType")).SelectedValue);
                    AnalysisDetail.RESULT_TEXT = ((TextBox)GridViewAnalyteData.FooterRow.FindControl("txtftrAnalytePercentage")).Text;
                    AnalysisDetail.EVAL_COMMENT_TEXT = ((TextBox)GridViewAnalyteData.FooterRow.FindControl("txtftrComments")).Text;
                    AnalysisDetail.CAS_NUMBER = ((TextBox)GridViewAnalyteData.FooterRow.FindControl("txtftrCASNumber")).Text;
                    AnalysisDetail.ANALYSIS_METHOD_NAME = ((TextBox)GridViewAnalyteData.FooterRow.FindControl("txtftrOthrAnalysisMthdTxt")).Text;
                    AnalysisDetail.OTHER_ANALYTETYPE_NAME = ((TextBox)GridViewAnalyteData.FooterRow.FindControl("txtftrAnalyteNm")).Text;
                    AnalysisDetail.STD_ANALYTETYPE_ID = Convert.ToInt32(((DropDownList)GridViewAnalyteData.FooterRow.Cells[1].Controls[3]).SelectedValue);
                }
                else if (e.CommandName == "AddNewRow") // Empty template
                {
                    var cmdSrc = e.CommandSource as Button;
                    if (cmdSrc != null)
                    {
                        GridViewRow Row = (GridViewRow)(cmdSrc.NamingContainer);
                        var ddledtMethodDesc = Row.FindControl("ddledtMethodDesc") as DropDownList;
                        if (ddledtMethodDesc != null)
                            AnalysisDetail.STD_ANALYSISMETHOD_ID = Convert.ToInt32(ddledtMethodDesc.SelectedValue);

                        var ddledtMethodType = Row.FindControl("ddledtMethodType") as DropDownList;
                        if (ddledtMethodType != null)
                            AnalysisDetail.STD_FRAGMENT_ANALYSIS_TYPE_ID = Convert.ToInt32(ddledtMethodType.SelectedValue);

                        AnalysisDetail.RESULT_TEXT = ((TextBox)Row.FindControl("txtedtAnalytePercentage")).Text;
                        AnalysisDetail.EVAL_COMMENT_TEXT = ((TextBox)Row.FindControl("txtedtComments")).Text;
                        AnalysisDetail.CAS_NUMBER = ((TextBox)Row.FindControl("txtedtCASNumber")).Text;
                        AnalysisDetail.ANALYSIS_METHOD_NAME = ((TextBox)Row.FindControl("txtedtOthrAnalysisMthdTxt")).Text;
                        AnalysisDetail.OTHER_ANALYTETYPE_NAME = ((TextBox)Row.FindControl("txtedtAnalyteNm")).Text;
                        AnalysisDetail.STD_ANALYTETYPE_ID = Convert.ToInt32(((DropDownList)Row.FindControl("ddledtAnalytes")).SelectedValue);
                    }
                }

                //Add a new Fragment if it does not exist
                if (Fragment == null)
                {
                    Fragment = AddNewFragment();
                    //Fragment.SetAsChangeTrackingRoot(EntityState.New);
                    //Fragment.SetAsInsertOnSubmit(true);
                    //Fragment.ANALYSIS_DETAILs.Add(AnalysisDetail);
                }

                Fragment.FRAGMENT_ANALYSIS_ID = FRAGMENT_ANALYSISManager.Save(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, Fragment);
                AnalysisDetail.FRAGMENT_ANALYSIS_ID = Fragment.FRAGMENT_ANALYSIS_ID;
                AnalysisDetail.ANALYSIS_DETAIL_ID = ANALYSIS_DETAILManager.Save(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, AnalysisDetail);

                SuppressSaveSuccessMessage = true;
                //Fragment.FRAGMENT_ANALYSIS_ID = FRAGMENT_ANALYSISManager.Save(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, Fragment);
                //manager.UpdateFragment(Fragment);
                GridViewAnalyteData.SelectedIndex = -1;
                GetRefreshFragment(Fragment.FRAGMENT_ANALYSIS_ID);
                BindGridView();
                SuppressSaveSuccessMessage = true;
            }
        }

        protected void GridViewAnalyteData_RowCreated(object sender, GridViewRowEventArgs e)
        {
        }

        protected void GridViewAnalyteData_RowDeleting(object sender, GridViewDeleteEventArgs e)
        {
            //ANALYSIS_DETAIL AnalysisDetail = ANALYSIS_DETAILManager.GetItem(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, AnalysisId);
            ANALYSIS_DETAILManager.Delete(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, AnalysisId);

            //ANALYSIS_DETAIL AnalysisDetail = Fragment.ANALYSIS_DETAILs.Where(d => d.ANALYSIS_DETAIL_ID == AnalysisId).SingleOrDefault();
            //Save Analysis detail here
            //AnalysisDetail.SetAsChangeTrackingRoot(true);
            //AnalysisDetail.SetAsDeleteOnSubmit(true);
            SuppressSaveSuccessMessage = true;
            Fragment.FRAGMENT_ANALYSIS_ID = FRAGMENT_ANALYSISManager.Save(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, Fragment);
            //manager.UpdateFragment(Fragment);
            //Do not highlight the row
            GridViewAnalyteData.SelectedIndex = -1;
            GetRefreshFragment(Fragment.FRAGMENT_ANALYSIS_ID);
            BindGridView();
        }

        //private FRAGMENT_ANALYSI AddNewFragment()
        private FRAGMENT_ANALYSIS AddNewFragment()
        {
            FRAGMENT_ANALYSIS NewFragment = new FRAGMENT_ANALYSIS();
            //FRAGMENT_ANALYSI NewFragment = new FRAGMENT_ANALYSI();
            int activityId;

            if (int.TryParse(Request.QueryString["activityId"], out activityId))
            {
                NewFragment.WKF_CASE_ACTIVITY_ID = activityId;
                NewFragment.LAB_ORDER_ID = GetLabOrderId(activityId);
            }
            NewFragment.RESULT_ACKNOWLEDGE_FLAG = false;

            NewFragment.CREATED = NewFragment.UPDATED = DateTime.Now;
            NewFragment.CREATEDBY = NewFragment.UPDATEDBY = CurrentUser;

            return NewFragment;
        }

        //protected override void LoadViewState(object savedState)
        //{
        //    base.LoadViewState(savedState);
        //    string fragmentXml = (string)ViewState["fragmentXml"];
        //    Fragment = SerializerUtil.Deserialize<FRAGMENT_ANALYSI>(fragmentXml);
        //}

        //protected override object SaveViewState()
        //{
        //    ViewState["fragmentXml"] = Fragment.Serialize();
        //    return base.SaveViewState();
        //}

        protected void CancelButton_Click(object sender, EventArgs e)
        {
            int activityId;
            if (int.TryParse(Request.QueryString["activityId"], out activityId))
                Response.Redirect(string.Format("FragLabResultDetails.aspx?ActivityId={0}", activityId), false);
        }

        protected void SaveButton_Click(object sender, EventArgs e)
        {
            //HightlightMenu();
            SaveCompleteFragment();
        }

        //private void HightlightMenu()
        //{
        //    Menu Mnu = (Menu)Master.FindControl("MenuLeftNavigation");
        //    bool Selected;
        //    MenuBuilder.SelectAndHighLightElement(Mnu.Items, "LabResults.aspx?OrderType=" + Convert.ToInt16(VIRP.EFR.BO.WorkflowCaseActivityStatus.InProcess), out Selected);
        //}

        /// <summary>
        /// Gets the lab order id for a lab results work flow activity Id
        /// </summary>
        /// <param name="ActivityId"></param>
        /// <returns></returns>
        private int GetLabOrderId(int ActivityId)
        {
            int labOrderId = 0;

            List<LAB_ORDER> orders = LAB_ORDERManager.GetItemsByActivity(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, ActivityId);
            if (orders != null && orders.Count > 0)
            {
                LAB_ORDER order = orders.First();
                labOrderId = order.LAB_ORDER_ID;
            }

            return labOrderId;

            //using (_db = GetDataContext())
            //{
            //    var order = //(from lo in _db.LAB_ORDERs
            //                 (from wc in _db.WKF_CASEs
            //                  where wc.WKF_CASE_ACTIVITies.Any(c => c.WKF_CASE_ACTIVITY_ID == ActivityId)
            //                  let c = wc.WKF_CASE_ACTIVITies.Where(c => c.STD_WKFACTIVITYTYPE_ID == Convert.ToInt16(WorkFlowActivityTypes.LabOrder)).SingleOrDefault()
            //                  select c.LAB_ORDERs.FirstOrDefault().LAB_ORDER_ID).FirstOrDefault();
            //    return (int)order;
            //}
        }

        protected override void Ds_Selecting(object sender, ObjectDataSourceSelectingEventArgs e)
        {
            ServiceInterfaceManager.LogInformation("POSTBACK_EVENT", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

            try
            {
                //e.InputParameters.Clear();

                //string txtSearch = TextBoxSearchCriteria.Text;
                //string listFacility = DropDownListFacility.SelectedValue;

                if (e.InputParameters["CURRENT_USER"] != null)
                    e.InputParameters["CURRENT_USER"] = HttpContext.Current.User.Identity.Name;
                else
                    e.InputParameters.Add("CURRENT_USER", HttpContext.Current.User.Identity.Name);

                if (e.InputParameters["CURRENT_REGISTRY_ID"] != null)
                    e.InputParameters["CURRENT_REGISTRY_ID"] = UserSession.CurrentRegistryId;
                else
                    e.InputParameters.Add("CURRENT_REGISTRY_ID", UserSession.CurrentRegistryId);

                //e.InputParameters.Add("lastName", txtSearch);
                //e.InputParameters.Add("facilityId", listFacility);
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }
    }
}
